<?php


namespace Wheregroup\DoctrineDbalShims\Event\Listeners;


use Doctrine\DBAL\Driver;
use Doctrine\DBAL\Driver\AbstractOracleDriver;
use Doctrine\DBAL\Driver\OCI8\Middleware\InitializeSession;
use Doctrine\DBAL\Platforms\OraclePlatform;

/**
 * Ensures DBAL-required session variables (like date format) are set on
 * Oracle connections. Unlike upstream OracleSessionInit, this listener automatically
 * checks if the connection is actually an Oracle connection. This allows mixing
 * multiple connections to different database servers, without the need to
 * preconfigure the listener to only process certain connections by name.
 */
class OnDemandOracleSessionInit extends InitializeSession
{
    public function wrap(Driver $driver): Driver
    {
        $platform = $driver->getDatabasePlatform();
        if ($platform instanceof OraclePlatform) {
            return parent::wrap($driver);
        }

        return $driver;
    }
}
