<?php


namespace Wheregroup\DoctrineDbalShims\DependencyInjection\Compiler;


use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

abstract class ShimPass implements CompilerPassInterface
{
    public abstract static function isShimRequired(ContainerBuilder $container): bool;

    /**
     * Registers the compiler pass (invariantly) to the container builder.
     */
    public static function register(ContainerBuilder $container): void
    {
        $container->addCompilerPass(new static());
    }

    /**
     * Registers the compiler pass to the container builder ONLY IF it
     * is required / applicable to current DBAL setup.
     */
    public static function autoRegister(ContainerBuilder $container): void
    {
        if (static::isShimRequired($container)) {
            static::register($container);
        }
    }

    /**
     * Utility method to register a compiler pass instance of the current class
     * before a certain other pass (by class name).
     * Performs no action unless a compiler pass of given $className was already
     * added to the builder.
     */
    protected static function registerBefore(ContainerBuilder $container, string $className): bool
    {
        $passConfig = $container->getCompilerPassConfig();
        $searchPasses = $passConfig->getBeforeOptimizationPasses();
        foreach ($searchPasses as $i => $pass) {
            if (is_a($pass, $className, true)) {
                array_splice($searchPasses, $i, 0, array(new static()));
                $passConfig->setBeforeOptimizationPasses($searchPasses);
                return true;
            }
        }
        return false;
    }
}
