<?php
namespace Mapbender\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @author Paul Schmidt
 */
#[ORM\MappedSuperclass]
abstract class SourceInstanceItem
{
    /**
     * @var integer $id
     */
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue(strategy: 'AUTO')]
    protected $id;

    /**
     * @var SourceInstance
     */
    protected $sourceInstance;

    /**
     * @var SourceItem
     */
    protected $sourceItem;

    #[ORM\Column(type: 'string', nullable: true)]
    protected $title;

    /**
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param integer $id
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return SourceInstance
     */
    public function getSourceInstance()
    {
        return $this->sourceInstance;
    }

    /**
     * @param SourceInstance|null $sourceInstance
     * @return $this
     */
    public function setSourceInstance(?SourceInstance $sourceInstance = NULL)
    {
        $this->sourceInstance = $sourceInstance;
        return $this;
    }

    /**
     * @return SourceItem
     */
    public function getSourceItem()
    {
        return $this->sourceItem;
    }

    /**
     * @param SourceItem $sourceItem
     * @return $this
     */
    public function setSourceItem(SourceItem $sourceItem)
    {
        $this->sourceItem = $sourceItem;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string|null $title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }
}
