<?php
namespace Mapbender\CoreBundle\Element;

use Mapbender\Component\Element\AbstractElementService;
use Mapbender\Component\Element\TemplateView;
use Mapbender\CoreBundle\Entity\Element;


/**
 * Spatial reference system selector
 *
 * Changes the map spatial reference system
 *
 * @author Paul Schmidt
 */
class SrsSelector extends AbstractElementService
{

    /**
     * @inheritdoc
     */
    public static function getClassTitle()
    {
        return "mb.core.srsselector.class.title";
    }

    /**
     * @inheritdoc
     */
    public static function getClassDescription()
    {
        return "mb.core.srsselector.class.description";
    }

    /**
     * @inheritdoc
     */
    public static function getType()
    {
        return 'Mapbender\CoreBundle\Element\Type\SrsSelectorAdminType';
    }

    /**
     * @inheritdoc
     */
    public function getRequiredAssets(Element $element)
    {
        return array(
            'js' => array(
                '@MapbenderCoreBundle/Resources/public/mapbender.element.srsselector.js',
            ),
            'css' => array(
                '@MapbenderCoreBundle/Resources/public/mapbender.element.srsselector.scss',
            ),
        );
    }

    /**
     * @inheritdoc
     */
    public static function getDefaultConfiguration()
    {
        return array(
            'tooltip' => static::getClassTitle(),
            'label' => false,
        );
    }

    /**
     * @inheritdoc
     */
    public function getWidgetName(Element $element)
    {
        return 'mapbender.mbSrsSelector';
    }

    public function getView(Element $element)
    {
        $view = new TemplateView('@MapbenderCore/Element/srsselector.html.twig');
        $config = $element->getConfiguration();
        $view->attributes = array(
            'class' => 'mb-element-srsselector',
            'title' => $config['tooltip'] ?: $element->getTitle(),
        );
        $view->variables = array(
            'label' => $config['label'] ? $element->getTitle() : null,
        );
        return $view;
    }

    /**
     * @inheritdoc
     */
    public static function getFormTemplate()
    {
        return '@MapbenderManager/Element/srsselector.html.twig';
    }

}
