<?php

namespace Mapbender\CoreBundle\Element\Type;

use Mapbender\CoreBundle\Entity\Element;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;


class POIAdminType extends AbstractType
{
    /**
     * @inheritdoc
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('useMailto', 'Symfony\Component\Form\Extension\Core\Type\CheckboxType', array(
                'required' => false,
                'label' => 'mb.core.admin.poi.label.usemailto',
            ))
            ->add('body', 'Symfony\Component\Form\Extension\Core\Type\TextType', array(
                'required' => true,
                'label' => 'mb.core.poi.admin.body',
            ))
            ->add('gps', 'Mapbender\ManagerBundle\Form\Type\Element\ControlTargetType', array(
                'required' => false,
                'label' => 'mb.core.poi.admin.gps',
                'include_buttons' => true,      // NOTE: GpsPosition is a button-type
                'element_filter_function' => function(Element $element) {
                    return \is_a($element->getClass(), 'Mapbender\CoreBundle\Element\GpsPosition', true);
                },
            ))
        ;
    }
}
